/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import noppes.npcs.LogWriter;
import noppes.npcs.client.model.ModelOBJPlayerArmor;
import noppes.npcs.client.renderer.data.CustomOBJState;
import noppes.npcs.client.renderer.data.ParameterizedModel;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.CustomArmor;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public class ModelBuffer {
    private static final List<ParameterizedModel> MODELS = new ArrayList<ParameterizedModel>();
    public static List<ResourceLocation> NOT_FOUND = new ArrayList<ResourceLocation>();
    private static ModelOBJPlayerArmor objModel;

    public static int getDisplayList(ResourceLocation objModel, List<String> visibleMeshes, Map<String, String> replacesMaterialTextures) {
        if (NOT_FOUND.contains(objModel)) {
            return -1;
        }
        ParameterizedModel model = new ParameterizedModel(-1, objModel, visibleMeshes, replacesMaterialTextures);
        for (ParameterizedModel pm : MODELS) {
            if (!pm.equals(model)) continue;
            model = pm;
            break;
        }
        if (model.listId < 0) {
            try {
                model.iModel = (OBJModel)OBJLoader.INSTANCE.loadModel(model.file);
                GL11.glPushMatrix();
                model.listId = GL11.glGenLists((int)1);
                GL11.glNewList((int)model.listId, (int)4864);
                Function<ResourceLocation, TextureAtlasSprite> spriteFunction = location -> {
                    TextureAtlasSprite sprite;
                    if (location.toString().equals("minecraft:missingno") || location.toString().equals("minecraft:builtin/white")) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                    ResourceLocation loc = location;
                    if (replacesMaterialTextures != null && replacesMaterialTextures.containsKey(location.toString())) {
                        loc = new ResourceLocation((String)replacesMaterialTextures.get(location.toString()));
                        LogWriter.debug("Replace texture: " + location + " -> " + loc);
                    }
                    if ((sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(loc.toString())) == Minecraft.func_71410_x().func_147117_R().func_174944_f()) {
                        LogWriter.debug("Not load or found texture sprite: " + loc + " to " + objModel);
                    }
                    return sprite;
                };
                if (model.visibleMeshes == null || model.visibleMeshes.isEmpty()) {
                    model.visibleMeshes = new ArrayList(model.iModel.getMatLib().getGroups().keySet());
                }
                IBakedModel bakedModel = model.iModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.copyOf(model.visibleMeshes), true), DefaultVertexFormats.field_176599_b, spriteFunction);
                GL11.glEnable((int)2929);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
                for (BakedQuad bakedquad : bakedModel.func_188616_a(null, null, 0L)) {
                    buffer.func_178981_a(bakedquad.func_178209_a());
                }
                tessellator.func_78381_a();
                GL11.glEndList();
                GL11.glPopMatrix();
                MODELS.add(model);
            }
            catch (Exception e) {
                NOT_FOUND.add(objModel);
                LogWriter.error("Error create OBJ \"" + objModel + "\" render list");
            }
        }
        return model.listId;
    }

    public static ResourceLocation getMainOBJTexture(ResourceLocation objModel) {
        try {
            ResourceLocation location = new ResourceLocation(objModel.func_110624_b(), objModel.func_110623_a().replace(".obj", ".mtl"));
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            String mat_lib = IOUtils.toString((InputStream)res.func_110527_b(), (Charset)StandardCharsets.UTF_8);
            if (mat_lib.contains("map_Kd")) {
                String path;
                int endIndex = mat_lib.indexOf("\n", mat_lib.indexOf("map_Kd"));
                if (endIndex == -1) {
                    endIndex = mat_lib.length();
                }
                String txtr = mat_lib.substring(mat_lib.indexOf(" ", mat_lib.indexOf("map_Kd")) + 1, endIndex);
                String domain = "";
                if (!txtr.contains(":")) {
                    path = txtr;
                } else {
                    domain = txtr.substring(0, txtr.indexOf(":"));
                    path = txtr.substring(txtr.indexOf(":") + 1);
                }
                return new ResourceLocation(domain, path);
            }
        }
        catch (IOException e) {
            LogWriter.error(e);
        }
        return null;
    }

    public static ModelBiped getOBJModelBiped(CustomArmor armor, EntityLivingBase entity, ModelBiped defModel) {
        if (!(entity instanceof EntityPlayer) && !(entity instanceof EntityNPCInterface)) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return defModel;
        }
        if (objModel == null) {
            objModel = new ModelOBJPlayerArmor(armor);
        }
        return objModel;
    }

    public static IBakedModel getIBakedModel(CustomArmor armor) {
        if (armor.objModel == null) {
            return null;
        }
        ArrayList<String> visibleMeshes = new ArrayList<String>();
        if (armor.func_185083_B_() == EntityEquipmentSlot.HEAD) {
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.HEAD));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.MOHAWK));
        } else if (armor.func_185083_B_() == EntityEquipmentSlot.CHEST) {
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.BODY));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.ARM_LEFT));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.ARM_RIGHT));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.WRIST_LEFT));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.WRIST_RIGHT));
        } else if (armor.func_185083_B_() == EntityEquipmentSlot.LEGS) {
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.BELT));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.LEG_LEFT));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.LEG_RIGHT));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.FOOT_LEFT));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.FOOT_RIGHT));
        } else if (armor.func_185083_B_() == EntityEquipmentSlot.FEET) {
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.FEET_LEFT));
            visibleMeshes.addAll(armor.getMeshNames(EnumParts.FEET_RIGHT));
        } else {
            return null;
        }
        try {
            OBJModel iModel = (OBJModel)OBJLoader.INSTANCE.loadModel(armor.objModel);
            Function<ResourceLocation, TextureAtlasSprite> spriteFunction = location -> {
                if (location.toString().equals("minecraft:missingno") || location.toString().equals("minecraft:builtin/white")) {
                    return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                }
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                if (sprite == Minecraft.func_71410_x().func_147117_R().func_174944_f()) {
                    LogWriter.debug("Not load or found texture sprite: " + location + " to " + (Object)((Object)objModel));
                }
                return sprite;
            };
            return iModel.bake((IModelState)new CustomOBJState((List<String>)ImmutableList.copyOf(visibleMeshes), true, armor), DefaultVertexFormats.field_176599_b, spriteFunction);
        }
        catch (Exception e) {
            LogWriter.error(e);
            return null;
        }
    }
}

